/**************************************************************************************
Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.
***************************************************************************************
$Id: EipDLR_Public.h 51162 2015-01-29 10:21:28Z kai $:

Description:
  Task EthernetIP DLR
  Public declaration of task

Changes:
 Date          Description
 -----------------------------------------------------------------------------------
 2010-11-01    created
**************************************************************************************/

/*
 *  Eip DLR - public definition of task
 *
 * The header contains the public definition of task.
 * It has to be included by another task to get access of task specfic definition.
 *
 * @note
 * The structures for the services must be packed on 1 byte of boundary.
 * The <code>#pragma</code> instructions are already planned for Microsoft compiler.
 * For gnu's compiler and Realview compiler the macros <code>__PACKED_PRE</code>
 * and <code>__PACKED_PRE</code> have to be added with the structural definition
 * in addition.
 */
#ifndef __EIP_DLR_PUBLIC_H
#define __EIP_DLR_PUBLIC_H


/*************************************************************************************/
/** queue name */
#define EIP_DLR_QUEUE_NAME        "QUE_EIP_DLR"

/*************************************************************************************/
/* DLR function API*/

TLR_RESULT
Eip_DLR_Open(TLR_HANDLE *hDLR,
             TLR_UINT32  ulInstance);

TLR_RESULT
Eip_DLR_Close(TLR_HANDLE *hDLR,
              TLR_UINT32  ulInstance);

TLR_RESULT
Eip_DLR_GetAttributeAll(TLR_HANDLE  hDLR,
                        TLR_VOID*   pvData,
                        TLR_UINT32* pulDataLen);

TLR_RESULT
Eip_DLR_GetAttributeSingle(TLR_HANDLE  hDLR,
                           TLR_VOID*   pvData,
                           TLR_UINT32* pulDataLen,
                           TLR_UINT32  ulInstance,
                           TLR_UINT32  ulAttribute);

typedef TLR_RESULT ( * EIP_DLR_GET_IP_ADDR_CALLBACK ) ( TLR_UINT32* pulIp,
                                                        VOID*       pvUserData);
TLR_RESULT
Eip_DLR_RegisterCallback_GetIpAddr(TLR_HANDLE                     hDLR,
                                   EIP_DLR_GET_IP_ADDR_CALLBACK   pfnCallback,
                                   TLR_VOID*                      pvUserData);

/* This callback function will be called by the DLR task whenever the network topology or network status changes. */

enum EIP_DLR_NETWORK_STATUS_Ttag{

  EIP_DLR_NW_STATUS_NORMAL = 0,
  EIP_DLR_NW_STATUS_RING_FAULT,
  EIP_DLR_NW_STATUS_UNEXP_LOOP,
  EIP_DLR_NW_STATUS_PARTIAL_NW_FAULT,
  EIP_DLR_NW_STATUS_RAPID_FAULT_RESTORE_CYCLE
};

enum EIP_DLR_NETWORK_TOPOLOGY_Ttag{

  EIP_DLR_NT_LINEAR = 0,
  EIP_DLR_NT_RING
};

typedef TLR_VOID ( * EIP_DLR_STATE_CHANGE_CALLBACK )( TLR_UINT8  bNetworkTopology,
                                                      TLR_UINT8  bNetworkStatus,
                                                      VOID*      pvUserData);
TLR_RESULT
Eip_DLR_RegisterCallback_StateChange( TLR_HANDLE                     hDLR,
                                      EIP_DLR_STATE_CHANGE_CALLBACK  pfnCallback,
                                      TLR_VOID*                      pvUserData);

/***************************************************************************************
* Eip DLR commands */

/* Indications that are used for internal use */
#define EIP_CMD_DLR_PROCESS_DLR_FRAME_IND          0x00006500
#define EIP_CMD_DLR_PROCESS_DLR_FRAME_RES          0x00006501

#define EIP_CMD_DLR_PROCESS_ETH_FRAME_IND          0x00006502
#define EIP_CMD_DLR_PROCESS_ETH_FRAME_RES          0x00006503

#define EIP_CMD_DLR_BEACON_TIMEOUT_IND             0x00006504
#define EIP_CMD_DLR_BEACON_TIMEOUT_RES             0x00006505

#define EIP_CMD_DLR_TIMEOUT_IND                    0x00006506
#define EIP_CMD_DLR_TIMEOUT_RES                    0x00006507

#define EIP_CMD_LINK_CHANGE_IND                    0x00006508
#define EIP_CMD_LINK_CHANGE_RES                    0x00006509

#define EIP_CMD_DLR_SET_CONFIG_REQ                 0x0000650A
#define EIP_CMD_DLR_SET_CONFIG_CNF                 0x0000650B

#define EIP_CMD_DLR_CIRCULATING_FRAME_IND          0x0000650C
#define EIP_CMD_DLR_CIRCULATING_FRAME_RES          0x0000650D

/*************************************************************************************/
/* packets */

/* pragma pack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_PACK_1(__EIP_DLR_PACKET)
#endif


typedef __PACKED_PRE struct __PACKED_POST EIP_DLR_PACKET_RECV_FRAME_IND_Ttag {
  TLR_PACKET_HEADER_T   tHead;
  EIP_DLR_FRAME_T       tData;
} EIP_DLR_PACKET_RECV_FRAME_IND_T;


#define EIP_DLR_PACKET_TIMEOUT_SIZE   0
typedef struct EIP_DLR_PACKET_TIMEOUT_Ttag{
  TLR_PACKET_HEADER_T         tHead;
}EIP_DLR_PACKET_TIMEOUT_T;



typedef __PACKED_PRE struct __PACKED_POST EIP_DLR_SET_CONFIG_REQ_DATA_Ttag {

  TLR_UINT8   fRingSvEnable;
  TLR_UINT8   bPrecedence;
  TLR_UINT32  ulBeaconInterval; /* in micro sec */
  TLR_UINT32  ulBeaconTimeout;  /* in micro sec */
  TLR_UINT16  usVlanID;

} EIP_DLR_SET_CONFIG_REQ_DATA_T;

#define EIP_DLR_PACKET_SET_CONFIG_REQ_SIZE  sizeof( EIP_DLR_SET_CONFIG_REQ_DATA_T )
typedef __PACKED_PRE struct __PACKED_POST EIP_DLR_PACKET_SET_CONFIG_REQ_Ttag {
  TLR_PACKET_HEADER_T             tHead;
  EIP_DLR_SET_CONFIG_REQ_DATA_T   tData;
} EIP_DLR_PACKET_SET_CONFIG_REQ_T;


typedef __PACKED_PRE struct __PACKED_POST EIP_DLR_PACKET_SET_CONFIG_CNF_Ttag {
  TLR_PACKET_HEADER_T             tHead;
} EIP_DLR_PACKET_SET_CONFIG_CNF_T;

/* pragma unpack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_UNPACK_1(__EIP_DLR_PACKET)
#endif

/*************************************************************************************/
#endif /* #ifndef __EIP_DLR_PUBLIC_H */
